## Overview

This repository contains the code for the paper:

> **Learning Without Augmenting: Unsupervised Time Series Representation Learning via Frame Projections**

The codebase supports multiple contrastive learning frameworks and datasets for time series representation learning.
Below are setup instructions and usage examples.

---

## Installation

We recommend using **Conda** for setting up the environment.

### Option 1: Create environment from `environment.yml`

```bash
conda env create -f environment.yml
conda activate ts_repr
```

### Option 2: Manual setup (if preferred)

```bash
conda create -n ts_repr python=3.8 -y
conda activate ts_repr
pip install -r requirements.txt
```

---

## Running Experiments

### Example: SimCLR framework with deterministic augmentations

```bash
python main.py --framework 'simclr' \
               --backbone 'resnet' \
               --dataset 'dalia' \
               --n_epoch 256 \
               --batch_size 1024 \
               --lr 1e-3 \
               --lr_cls 0.03 \
               --out_dim 384 \
               --cuda 0 \
               --cases 'subject_large' \
               --aug1 'perm_jit' \
               --aug2 'scale'
```

### Example: SimCLR framework with random augmentations from a set

```bash
python main.py --framework 'simclr' \
               --backbone 'resnet' \
               --dataset 'dalia' \
               --n_epoch 256 \
               --batch_size 1024 \
               --lr 1e-3 \
               --lr_cls 0.03 \
               --out_dim 384 \
               --cuda 0 \
               --cases 'subject_large' \
               --aug1 'random' \
               --aug2 'random'
```

### Example: Our framework 

```bash
python main.py --framework 'isoalign' \
               --backbone 'resnet' \
               --dataset 'dalia' \
               --n_epoch 256 \
               --batch_size 1024 \
               --lr 1e-3 \
               --lr_cls 0.03 \
               --out_dim 128 \
               --cuda 0 \
               --cases 'subject_large'
```

### Supervised experiments

```bash
python main_supervised_baseline.py \
               --dataset 'dalia' \
               --backbone 'resnet' \
               --block 8 \
               --lr 1e-3 \
               --n_epoch 999 \
               --cuda 0
```

---

## Notes

* Make sure the dataset files are placed in the correct directory structure (refer to the `data_preprocess` folder for expected formats and paths).
* Implementations of related methods are available in the `models` folder.
* The `cache` folder is used to store precomputed wavelet coefficients to avoid redundant computation.
* Backbone architectures are implemented in the `backbones.py` and `models_nc.py` scripts.

## Credits

This codebase builds upon the structure and components from the following open-source repositories:

* [CL-HAR](https://github.com/Tian0426/CL-HAR)
* [TFC](https://github.com/mims-harvard/TFC-pretraining)
* [Finding Order in Chaos](https://github.com/eth-siplab/Finding_Order_in_Chaos)

We thank the authors for making their work publicly available.



